rm(list=ls())

library('MASS')
library(copula)
library(Rlab)
library(matlib)
library(xtable)
#install.packages("copula")
#install.packages("Rlab")
#install.packages("matlib")
#install.packages("xtable")

r<-1
tau<- 0.8
UCL<-19.71
#generate data from mix copula to estimate mean and covariance
theta_clayton<-iTau(claytonCopula(),tau = tau)
theta_gumbel<-iTau(gumbelCopula(),tau = tau)
theta_frank<-iTau(frankCopula(),tau = tau)
#define copula with standard normal marginals
copula_clayton<-mvdc(claytonCopula(param=theta_clayton,dim=2)
                     ,margins = c("norm","norm"),
                     paramMargins =
                       list(list(mean=0,sd=1),list(mean=0, sd=1)))
copula_gumbel<-mvdc(gumbelCopula(param=theta_gumbel,dim=2)
                    ,margins = c("norm","norm"),
                    paramMargins =
                      list(list(mean=0,sd=1),list(mean=0, sd=1)))

copula_frank<-mvdc(frankCopula(param=theta_frank,dim=2)
                   ,margins = c("norm","norm"),
                   paramMargins =
                     list(list(mean=0,sd=1),list(mean=0, sd=1)))
#Estimate mean and covariance matrix
mu<-matrix(NA, ncol=2,nrow=1000)
a<-c(0)
b<-c(0)
c<-c(0)
for (i in 1:1000)
{
  #Sample N random uniforms U
  N<-1000
  U =runif(N)
  #Variable to store the samples from the mixture distribution                                             
  rand.sample = matrix(NA,ncol=2,nrow=N)
  #Sampling from the mixture
  for(k in 1:N){
    if(U[k]<1/3){
      rand.sample[k,] = rMvdc(1,copula_clayton)
    }else if(U[k]<2/3){
      rand.sample[k,] = rMvdc(1,copula_gumbel)
    }else{
      rand.sample[k,] = rMvdc(1,copula_frank)
    }
  }
    mu[i,]<-apply(rand.sample,2,mean)
  a[i]<-cov(rand.sample[,1],rand.sample[,1])
  b[i]<-cov(rand.sample[,2],rand.sample[,2])
  c[i]<-cov(rand.sample[,1],rand.sample[,2])
}

muhat<-apply(mu,2,mean)
segma<-matrix(c(mean(a),mean(c),mean(c),mean(b)),ncol=2)
muhat
segma

                          #----start ARL------#
delta1<-1.5  #shift for first variable
delta2<-1.5   #shift for second variable
copula_clayton<-mvdc(claytonCopula(param=theta_clayton,dim=2)
                     ,margins = c("norm","norm"),
                     paramMargins =
                       list(list(mean=delta1,sd=1),list(mean=delta2, sd=1)))
copula_gumbel<-mvdc(gumbelCopula(param=theta_gumbel,dim=2)
                    ,margins = c("norm","norm"),
                    paramMargins =
                      list(list(mean=delta1,sd=1),list(mean=delta2, sd=1)))

copula_frank<-mvdc(frankCopula(param=theta_frank,dim=2)
                   ,margins = c("norm","norm"),
                   paramMargins =
                     list(list(mean=delta1,sd=1),list(mean=delta2, sd=1)))

  ARL<-c(0)
  for(ii in 1:5000)
  {
    Z<-matrix(c(0,0),ncol=1)
    RL<-0
    E<-0 
    j<-1
    while(E < UCL )
    {
      U =runif(1)
      if(U<1/3){
        X = matrix(rMvdc(1,copula_clayton),ncol=1)
      }else if(U<2/3){
        X = matrix(rMvdc(1,copula_gumbel),ncol=1)
      }else{
        X = matrix(rMvdc(1,copula_frank),ncol=1)
      }
      segmahat<-(r*(1-(1-r)^(2*j))/(2-r))*segma  
      Z<- r*(X-muhat)+(1-r)*Z
      E<-t(Z)%*%inv(segmahat)%*%Z
      RL<-RL+1
      j<-j+1
    } 
   ARL[ii]<-RL
  }
  ARLe<-mean(ARL)
  ARLe

  
  